<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use App\Repository\TGovernorOfficesRepository;
use Doctrine\ORM\Mapping as ORM;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;

use ApiPlatform\Core\Annotation\ApiFilter;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\SearchFilter;
use ApiPlatform\Core\Serializer\Filter\PropertyFilter;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * @ApiResource(
 *    normalizationContext={"groups"={"t_governor_offices:read"}, "enable_max_depth"="true", "swagger_definition_name"="Read"},
 *    denormalizationContext={"groups"={"t_governor_offices:write"}, "swagger_definition_name"="Write"}
 * )
 * @ApiFilter(SearchFilter::class, properties={ "id": "exact" })
 * @ApiFilter(PropertyFilter::class)
 * @ORM\Entity(repositoryClass=TGovernorOfficesRepository::class)
 */

class TGovernorOffices
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     * @Groups({ "t_governor_offices:read", "t_governor_offices:write", "t_county_sectors:read" })
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({ "t_governor_offices:read", "t_governor_offices:write" })
     */
    private $name;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     * @Groups({ "t_governor_offices:read", "t_governor_offices:write" })
     */
    private $alias;

    /**
     * @ORM\OneToMany(targetEntity=TCountySectors::class, mappedBy="governorOffice")
     */
    private $tCountySectors;

    public function __construct()
    {
        $this->tCountySectors = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getName(): ?string
    {
        return $this->name;
    }

    public function setName(?string $name): self
    {
        $this->name = $name;

        return $this;
    }

    public function getAlias(): ?string
    {
        return $this->alias;
    }

    public function setAlias(?string $alias): self
    {
        $this->alias = $alias;

        return $this;
    }

    /**
     * @return Collection|TCountySectors[]
     */
    public function getTCountySectors(): Collection
    {
        return $this->tCountySectors;
    }

    public function addTCountySector(TCountySectors $tCountySector): self
    {
        if (!$this->tCountySectors->contains($tCountySector)) {
            $this->tCountySectors[] = $tCountySector;
            $tCountySector->setGovernorOffice($this);
        }

        return $this;
    }

    public function removeTCountySector(TCountySectors $tCountySector): self
    {
        if ($this->tCountySectors->removeElement($tCountySector)) {
            // set the owning side to null (unless already changed)
            if ($tCountySector->getGovernorOffice() === $this) {
                $tCountySector->setGovernorOffice(null);
            }
        }

        return $this;
    }
}
