<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use App\Repository\TCountyDepartmentsAdpProjectsRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

use ApiPlatform\Core\Annotation\ApiFilter;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\SearchFilter;
use ApiPlatform\Core\Serializer\Filter\PropertyFilter;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * @ApiResource(
 *    normalizationContext={"groups"={"t_county_departments_adp_projects:read"}, "enable_max_depth"="true", "swagger_definition_name"="Read"},
 *    denormalizationContext={"groups"={"t_county_departments_adp_projects:write"}, "swagger_definition_name"="Write"}
 * )
 * @ApiFilter(SearchFilter::class, properties={ "id": "exact", "sector": "exact", "department": "exact" })
 * @ApiFilter(PropertyFilter::class)
 * @ORM\Entity(repositoryClass=TCountyDepartmentsAdpProjectsRepository::class)
 */

class TCountyDepartmentsAdpProjects
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     * @Groups({ "t_county_departments_adp_projects:read", "t_county_departments_adp_projects:write", "t_milestones:read" })
     */
    private $id;

    /**
     * @ORM\ManyToOne(targetEntity=TFinancialYears::class, inversedBy="tCountyDepartmentsAdpProjects")
     * @Groups({ "t_county_departments_adp_projects:read", "t_county_departments_adp_projects:write" })
     */
    private $financialYear;

    /**
     * @ORM\ManyToOne(targetEntity=TCountySectorsAdpProjects::class, inversedBy="tCountyDepartmentsAdpProjects")
     * @Groups({ "t_county_departments_adp_projects:read", "t_county_departments_adp_projects:write" })
     */
    private $sectorAdpProject;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({ "t_county_departments_adp_projects:read", "t_county_departments_adp_projects:write" })
     */
    private $target;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({ "t_county_departments_adp_projects:read", "t_county_departments_adp_projects:write", "t_county_sectors:read" })
     */
    private $budgetAllocation;

    /**
     * @ORM\Column(type="text", nullable=true)
     * @Groups({ "t_county_departments_adp_projects:read", "t_county_departments_adp_projects:write", "t_directorates_adp_projects:read" })
     */
    private $projectName;

    /**
     * @ORM\Column(type="date", nullable=true)
     * @Groups({ "t_county_departments_adp_projects:read", "t_county_departments_adp_projects:write", "t_directorates_adp_projects:read" })
     */
    private $startDate;

    /**
     * @ORM\Column(type="date", nullable=true)
     * @Groups({ "t_county_departments_adp_projects:read", "t_county_departments_adp_projects:write", "t_directorates_adp_projects:read" })
     */
    private $endDate;

    /**
     * @ORM\ManyToOne(targetEntity=TCountyDepartments::class, inversedBy="tCountyDepartmentsAdpProjects")
     * @Groups({ "t_county_departments_adp_projects:read", "t_county_departments_adp_projects:write" })
     */
    private $department;

    /**
     * @ORM\OneToMany(targetEntity=TMilestones::class, mappedBy="departmentProject")
     * @Groups({ "t_county_departments_adp_projects:read", "t_county_departments_adp_projects:write" })
     */
    private $tMilestones;

    /**
     * @ORM\ManyToOne(targetEntity=TDirectorates::class, inversedBy="tCountyDepartmentsAdpProjects")
     * @Groups({ "t_county_departments_adp_projects:read", "t_county_departments_adp_projects:write" })
     */
    private $directorate;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({ "t_county_departments_adp_projects:read", "t_county_departments_adp_projects:write", "t_county_sectors:read" })
     */
    private $progressPercent;

    /**
     * @ORM\ManyToOne(targetEntity=TCountySectors::class, inversedBy="tCountyDepartmentsAdpProjects")
     * @Groups({ "t_county_departments_adp_projects:read", "t_county_departments_adp_projects:write" })
     */
    private $sector;

    /**
     * @ORM\OneToMany(targetEntity=TProjectLocationMaps::class, mappedBy="departmentProject")
     */
    private $tProjectLocationMaps;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     * @Groups({ "t_county_departments_adp_projects:read", "t_county_departments_adp_projects:write" })
     */
    private $latitude;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     * @Groups({ "t_county_departments_adp_projects:read", "t_county_departments_adp_projects:write" })
     */
    private $longitude;

    /**
     * @ORM\Column(type="text", nullable=true)
     * @Groups({ "t_county_departments_adp_projects:read", "t_county_departments_adp_projects:write" })
     */
    private $projectLocation;

    /**
     * @ORM\Column(type="text", nullable=true)
     * @Groups({ "t_county_departments_adp_projects:read", "t_county_departments_adp_projects:write" })
     */
    private $projectDescription;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({ "t_county_departments_adp_projects:read", "t_county_departments_adp_projects:write" })
     */
    private $continueOrNew;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({ "t_county_departments_adp_projects:read", "t_county_departments_adp_projects:write" })
     */
    private $baseline;

    
    public function __construct()
    {
        $this->tMilestones = new ArrayCollection();
        $this->tProjectLocationMaps = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getFinancialYear(): ?TFinancialYears
    {
        return $this->financialYear;
    }

    public function setFinancialYear(?TFinancialYears $financialYear): self
    {
        $this->financialYear = $financialYear;

        return $this;
    }

    public function getSectorAdpProject(): ?TCountySectorsAdpProjects
    {
        return $this->sectorAdpProject;
    }

    public function setSectorAdpProject(?TCountySectorsAdpProjects $sectorAdpProject): self
    {
        $this->sectorAdpProject = $sectorAdpProject;

        return $this;
    }

    public function getTarget(): ?string
    {
        return $this->target;
    }

    public function setTarget(?string $target): self
    {
        $this->target = $target;

        return $this;
    }

    public function getBudgetAllocation(): ?string
    {
        return $this->budgetAllocation;
    }

    public function setBudgetAllocation(?string $budgetAllocation): self
    {
        $this->budgetAllocation = $budgetAllocation;

        return $this;
    }

    public function getProjectName(): ?string
    {
        return $this->projectName;
    }

    public function setProjectName(?string $projectName): self
    {
        $this->projectName = $projectName;

        return $this;
    }

    public function getStartDate(): ?\DateTimeInterface
    {
        return $this->startDate;
    }

    public function setStartDate(?\DateTimeInterface $startDate): self
    {
        $this->startDate = $startDate;

        return $this;
    }

    public function getEndDate(): ?\DateTimeInterface
    {
        return $this->endDate;
    }

    public function setEndDate(?\DateTimeInterface $endDate): self
    {
        $this->endDate = $endDate;

        return $this;
    }

    public function getDepartment(): ?TCountyDepartments
    {
        return $this->department;
    }

    public function setDepartment(?TCountyDepartments $department): self
    {
        $this->department = $department;

        return $this;
    }

    /**
     * @return Collection|TMilestones[]
     */
    public function getTMilestones(): Collection
    {
        return $this->tMilestones;
    }

    public function addTMilestone(TMilestones $tMilestone): self
    {
        if (!$this->tMilestones->contains($tMilestone)) {
            $this->tMilestones[] = $tMilestone;
            $tMilestone->setDepartmentProject($this);
        }

        return $this;
    }

    public function removeTMilestone(TMilestones $tMilestone): self
    {
        if ($this->tMilestones->removeElement($tMilestone)) {
            // set the owning side to null (unless already changed)
            if ($tMilestone->getDepartmentProject() === $this) {
                $tMilestone->setDepartmentProject(null);
            }
        }

        return $this;
    }

    public function getDirectorate(): ?TDirectorates
    {
        return $this->directorate;
    }

    public function setDirectorate(?TDirectorates $directorate): self
    {
        $this->directorate = $directorate;

        return $this;
    }

    public function getProgressPercent(): ?string
    {
        return $this->progressPercent;
    }

    public function setProgressPercent(?string $progressPercent): self
    {
        $this->progressPercent = $progressPercent;

        return $this;
    }

    public function getSector(): ?TCountySectors
    {
        return $this->sector;
    }

    public function setSector(?TCountySectors $sector): self
    {
        $this->sector = $sector;

        return $this;
    }

    /**
     * @return Collection|TProjectLocationMaps[]
     */
    public function getTProjectLocationMaps(): Collection
    {
        return $this->tProjectLocationMaps;
    }

    public function addTProjectLocationMap(TProjectLocationMaps $tProjectLocationMap): self
    {
        if (!$this->tProjectLocationMaps->contains($tProjectLocationMap)) {
            $this->tProjectLocationMaps[] = $tProjectLocationMap;
            $tProjectLocationMap->setDepartmentProject($this);
        }

        return $this;
    }

    public function removeTProjectLocationMap(TProjectLocationMaps $tProjectLocationMap): self
    {
        if ($this->tProjectLocationMaps->removeElement($tProjectLocationMap)) {
            // set the owning side to null (unless already changed)
            if ($tProjectLocationMap->getDepartmentProject() === $this) {
                $tProjectLocationMap->setDepartmentProject(null);
            }
        }

        return $this;
    }

    public function getLatitude(): ?string
    {
        return $this->latitude;
    }

    public function setLatitude(?string $latitude): self
    {
        $this->latitude = $latitude;

        return $this;
    }

    public function getLongitude(): ?string
    {
        return $this->longitude;
    }

    public function setLongitude(?string $longitude): self
    {
        $this->longitude = $longitude;

        return $this;
    }

    public function getProjectLocation(): ?string
    {
        return $this->projectLocation;
    }

    public function setProjectLocation(?string $projectLocation): self
    {
        $this->projectLocation = $projectLocation;

        return $this;
    }

    public function getProjectDescription(): ?string
    {
        return $this->projectDescription;
    }

    public function setProjectDescription(?string $projectDescription): self
    {
        $this->projectDescription = $projectDescription;

        return $this;
    }

    public function getContinueOrNew(): ?string
    {
        return $this->continueOrNew;
    }

    public function setContinueOrNew(?string $continueOrNew): self
    {
        $this->continueOrNew = $continueOrNew;

        return $this;
    }

    public function getBaseline(): ?string
    {
        return $this->baseline;
    }

    public function setBaseline(?string $baseline): self
    {
        $this->baseline = $baseline;

        return $this;
    }
    
}
