<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use App\Repository\TAppraisalsRatingScaleRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

use ApiPlatform\Core\Annotation\ApiFilter;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\SearchFilter;
use ApiPlatform\Core\Serializer\Filter\PropertyFilter;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * @ApiResource(
 *    normalizationContext={"groups"={"t_appraisals_rating_scale:read"}, "enable_max_depth"="true", "swagger_definition_name"="Read"},
 *    denormalizationContext={"groups"={"t_appraisals_rating_scale:write"}, "swagger_definition_name"="Write"}
 * )
 * @ApiFilter(SearchFilter::class, properties={ "id": "exact", "directorate": "exact", "progressStatus": "exact" })
 * @ApiFilter(PropertyFilter::class)
 * @ORM\Entity(repositoryClass=TAppraisalsRatingScaleRepository::class)
 */

class TAppraisalsRatingScale
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     * @Groups({ "t_appraisals_rating_scale:read", "t_appraisals_rating_scale:write" })
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     * @Groups({ "t_appraisals_rating_scale:read", "t_appraisals_rating_scale:write" })
     */
    private $item;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     * @Groups({ "t_appraisals_rating_scale:read", "t_appraisals_rating_scale:write", "t_appraisals_performance_targets:read" })
     */
    private $remarks;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({ "t_appraisals_rating_scale:read", "t_appraisals_rating_scale:write" })
     */
    private $scale;

    /**
     * @ORM\OneToMany(targetEntity=TAppraisalsPerformanceTargets::class, mappedBy="midYearPerformanceRating")
     */
    private $tAppraisalsPerformanceTargets;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({ "t_appraisals_rating_scale:read", "t_appraisals_rating_scale:write" })
     */
    private $rateMin;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({ "t_appraisals_rating_scale:read", "t_appraisals_rating_scale:write" })
     */
    private $rateMax;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     * @Groups({ "t_appraisals_rating_scale:read", "t_appraisals_rating_scale:write" })
     */
    private $rateDescription;

    public function __construct()
    {
        $this->tAppraisalsPerformanceTargets = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getItem(): ?string
    {
        return $this->item;
    }

    public function setItem(?string $item): self
    {
        $this->item = $item;

        return $this;
    }

    public function getRemarks(): ?string
    {
        return $this->remarks;
    }

    public function setRemarks(?string $remarks): self
    {
        $this->remarks = $remarks;

        return $this;
    }

    public function getScale(): ?string
    {
        return $this->scale;
    }

    public function setScale(?string $scale): self
    {
        $this->scale = $scale;

        return $this;
    }

    /**
     * @return Collection|TAppraisalsPerformanceTargets[]
     */
    public function getTAppraisalsPerformanceTargets(): Collection
    {
        return $this->tAppraisalsPerformanceTargets;
    }

    public function addTAppraisalsPerformanceTarget(TAppraisalsPerformanceTargets $tAppraisalsPerformanceTarget): self
    {
        if (!$this->tAppraisalsPerformanceTargets->contains($tAppraisalsPerformanceTarget)) {
            $this->tAppraisalsPerformanceTargets[] = $tAppraisalsPerformanceTarget;
            $tAppraisalsPerformanceTarget->setMidYearPerformanceRating($this);
        }

        return $this;
    }

    public function removeTAppraisalsPerformanceTarget(TAppraisalsPerformanceTargets $tAppraisalsPerformanceTarget): self
    {
        if ($this->tAppraisalsPerformanceTargets->removeElement($tAppraisalsPerformanceTarget)) {
            // set the owning side to null (unless already changed)
            if ($tAppraisalsPerformanceTarget->getMidYearPerformanceRating() === $this) {
                $tAppraisalsPerformanceTarget->setMidYearPerformanceRating(null);
            }
        }

        return $this;
    }

    public function getRateMin(): ?string
    {
        return $this->rateMin;
    }

    public function setRateMin(?string $rateMin): self
    {
        $this->rateMin = $rateMin;

        return $this;
    }

    public function getRateMax(): ?string
    {
        return $this->rateMax;
    }

    public function setRateMax(?string $rateMax): self
    {
        $this->rateMax = $rateMax;

        return $this;
    }

    public function getRateDescription(): ?string
    {
        return $this->rateDescription;
    }

    public function setRateDescription(?string $rateDescription): self
    {
        $this->rateDescription = $rateDescription;

        return $this;
    }

}
