<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use App\Repository\TAppraisalsPerformanceTargetsRepository;
use Doctrine\ORM\Mapping as ORM;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;

use ApiPlatform\Core\Annotation\ApiFilter;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\SearchFilter;
use ApiPlatform\Core\Serializer\Filter\PropertyFilter;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * @ApiResource(
 *    normalizationContext={"groups"={"t_appraisals_performance_targets:read"}, "enable_max_depth"="true", "swagger_definition_name"="Read"},
 *    denormalizationContext={"groups"={"t_appraisals_performance_targets:write"}, "swagger_definition_name"="Write"}
 * )
 * @ApiFilter(SearchFilter::class, properties={ "id": "exact", "directorate": "exact", "progressStatus": "exact" })
 * @ApiFilter(PropertyFilter::class)
 * @ORM\Entity(repositoryClass=TAppraisalsPerformanceTargetsRepository::class)
 */

class TAppraisalsPerformanceTargets
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     * @Groups({ "t_appraisals_performance_targets:read", "t_appraisals_performance_targets:write" })
     */
    private $id;

    /**
     * @ORM\Column(type="text", nullable=true)
     * @Groups({ "t_appraisals_performance_targets:read", "t_appraisals_performance_targets:write" })
     */
    private $item;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     * @Groups({ "t_appraisals_performance_targets:read", "t_appraisals_performance_targets:write" })
     */
    private $indicator;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({ "t_appraisals_performance_targets:read", "t_appraisals_performance_targets:write" })
     */
    private $target;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({ "t_appraisals_performance_targets:read", "t_appraisals_performance_targets:write" })
     */
    private $midYearResults;

    /**
     * @ORM\ManyToOne(targetEntity=TAppraisalsRatingScale::class, inversedBy="tAppraisalsPerformanceTargets")
     * @Groups({ "t_appraisals_performance_targets:read", "t_appraisals_performance_targets:write" })
     */
    private $midYearRating;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({ "t_appraisals_performance_targets:read", "t_appraisals_performance_targets:write" })
     */
    private $endYearResults;

    /**
     * @ORM\ManyToOne(targetEntity=TAppraisalsRatingScale::class, inversedBy="tAppraisalsPerformanceTargets")
     * @Groups({ "t_appraisals_performance_targets:read", "t_appraisals_performance_targets:write" })
     */
    private $endYearRating;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({ "t_appraisals_performance_targets:read", "t_appraisals_performance_targets:write" })
     */
    private $midYearSelfAssessment;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({ "t_appraisals_performance_targets:read", "t_appraisals_performance_targets:write" })
     */
    private $midYearActualAssessment;

    /**
     * @ORM\ManyToOne(targetEntity=TAppraisalsRatingScale::class, inversedBy="tAppraisalsPerformanceTargets")
     * @Groups({ "t_appraisals_performance_targets:read", "t_appraisals_performance_targets:write" })
     */
    private $midYearPerformanceRating;

    /**
     * @ORM\Column(type="text", nullable=true)
     * @Groups({ "t_appraisals_performance_targets:read", "t_appraisals_performance_targets:write" })
     */
    private $midYearRemarks;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({ "t_appraisals_performance_targets:read", "t_appraisals_performance_targets:write" })
     */
    private $midSelfMeanPercentScore;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({ "t_appraisals_performance_targets:read", "t_appraisals_performance_targets:write" })
     */
    private $midActualMeanPercentScore;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({ "t_appraisals_performance_targets:read", "t_appraisals_performance_targets:write" })
     */
    private $midTargetNumber;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({ "t_appraisals_performance_targets:read", "t_appraisals_performance_targets:write" })
     */
    private $endYearSelfAssessment;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({ "t_appraisals_performance_targets:read", "t_appraisals_performance_targets:write" })
     */
    private $endYearActualAssessment;

    /**
     * @ORM\ManyToOne(targetEntity=TAppraisalsRatingScale::class, inversedBy="tAppraisalsPerformanceTargets")
     * @Groups({ "t_appraisals_performance_targets:read", "t_appraisals_performance_targets:write" })
     */
    private $endYearPerformanceRating;

    /**
     * @ORM\Column(type="text", nullable=true)
     * @Groups({ "t_appraisals_performance_targets:read", "t_appraisals_performance_targets:write" })
     */
    private $endYearRemarks;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({ "t_appraisals_performance_targets:read", "t_appraisals_performance_targets:write" })
     */
    private $endTargetNumber;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({ "t_appraisals_performance_targets:read", "t_appraisals_performance_targets:write" })
     */
    private $endSelfMeanPercentScore;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({ "t_appraisals_performance_targets:read", "t_appraisals_performance_targets:write" })
     */
    private $endActualMeanPercentScore;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     * @Groups({ "t_appraisals_performance_targets:read", "t_appraisals_performance_targets:write" })
     */
    private $status;

    /**
     * @ORM\Column(type="date", nullable=true)
     * @Groups({ "t_appraisals_performance_targets:read", "t_appraisals_performance_targets:write" })
     */
    private $startDate;

    /**
     * @ORM\Column(type="date", nullable=true)
     * @Groups({ "t_appraisals_performance_targets:read", "t_appraisals_performance_targets:write" })
     */
    private $endDate;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getItem(): ?string
    {
        return $this->item;
    }

    public function setItem(?string $item): self
    {
        $this->item = $item;

        return $this;
    }

    public function getIndicator(): ?string
    {
        return $this->indicator;
    }

    public function setIndicator(?string $indicator): self
    {
        $this->indicator = $indicator;

        return $this;
    }

    public function getTarget(): ?string
    {
        return $this->target;
    }

    public function setTarget(?string $target): self
    {
        $this->target = $target;

        return $this;
    }

    public function getMidYearResults(): ?string
    {
        return $this->midYearResults;
    }

    public function setMidYearResults(?string $midYearResults): self
    {
        $this->midYearResults = $midYearResults;

        return $this;
    }

    public function getMidYearRating(): ?TAppraisalsRatingScale
    {
        return $this->midYearRating;
    }

    public function setMidYearRating(?TAppraisalsRatingScale $midYearRating): self
    {
        $this->midYearRating = $midYearRating;

        return $this;
    }

    public function getEndYearResults(): ?string
    {
        return $this->endYearResults;
    }

    public function setEndYearResults(?string $endYearResults): self
    {
        $this->endYearResults = $endYearResults;

        return $this;
    }

    public function getEndYearRating(): ?TAppraisalsRatingScale
    {
        return $this->endYearRating;
    }

    public function setEndYearRating(?TAppraisalsRatingScale $endYearRating): self
    {
        $this->endYearRating = $endYearRating;

        return $this;
    }

    public function getMidYearSelfAssessment(): ?string
    {
        return $this->midYearSelfAssessment;
    }

    public function setMidYearSelfAssessment(?string $midYearSelfAssessment): self
    {
        $this->midYearSelfAssessment = $midYearSelfAssessment;

        return $this;
    }

    public function getMidYearActualAssessment(): ?string
    {
        return $this->midYearActualAssessment;
    }

    public function setMidYearActualAssessment(?string $midYearActualAssessment): self
    {
        $this->midYearActualAssessment = $midYearActualAssessment;

        return $this;
    }

    public function getMidYearPerformanceRating(): ?TAppraisalsRatingScale
    {
        return $this->midYearPerformanceRating;
    }

    public function setMidYearPerformanceRating(?TAppraisalsRatingScale $midYearPerformanceRating): self
    {
        $this->midYearPerformanceRating = $midYearPerformanceRating;

        return $this;
    }

    public function getMidYearRemarks(): ?string
    {
        return $this->midYearRemarks;
    }

    public function setMidYearRemarks(?string $midYearRemarks): self
    {
        $this->midYearRemarks = $midYearRemarks;

        return $this;
    }

    public function getMidSelfMeanPercentScore(): ?string
    {
        return $this->midSelfMeanPercentScore;
    }

    public function setMidSelfMeanPercentScore(?string $midSelfMeanPercentScore): self
    {
        $this->midSelfMeanPercentScore = $midSelfMeanPercentScore;

        return $this;
    }

    public function getMidActualMeanPercentScore(): ?string
    {
        return $this->midActualMeanPercentScore;
    }

    public function setMidActualMeanPercentScore(?string $midActualMeanPercentScore): self
    {
        $this->midActualMeanPercentScore = $midActualMeanPercentScore;

        return $this;
    }

    public function getMidTargetNumber(): ?string
    {
        return $this->midTargetNumber;
    }

    public function setMidTargetNumber(?string $midTargetNumber): self
    {
        $this->midTargetNumber = $midTargetNumber;

        return $this;
    }

    public function getEndYearSelfAssessment(): ?string
    {
        return $this->endYearSelfAssessment;
    }

    public function setEndYearSelfAssessment(?string $endYearSelfAssessment): self
    {
        $this->endYearSelfAssessment = $endYearSelfAssessment;

        return $this;
    }

    public function getEndYearActualAssessment(): ?string
    {
        return $this->endYearActualAssessment;
    }

    public function setEndYearActualAssessment(?string $endYearActualAssessment): self
    {
        $this->endYearActualAssessment = $endYearActualAssessment;

        return $this;
    }

    public function getEndYearPerformanceRating(): ?TAppraisalsRatingScale
    {
        return $this->endYearPerformanceRating;
    }

    public function setEndYearPerformanceRating(?TAppraisalsRatingScale $endYearPerformanceRating): self
    {
        $this->endYearPerformanceRating = $endYearPerformanceRating;

        return $this;
    }

    public function getEndYearRemarks(): ?string
    {
        return $this->endYearRemarks;
    }

    public function setEndYearRemarks(?string $endYearRemarks): self
    {
        $this->endYearRemarks = $endYearRemarks;

        return $this;
    }

    public function getEndTargetNumber(): ?string
    {
        return $this->endTargetNumber;
    }

    public function setEndTargetNumber(?string $endTargetNumber): self
    {
        $this->endTargetNumber = $endTargetNumber;

        return $this;
    }

    public function getEndSelfMeanPercentScore(): ?string
    {
        return $this->endSelfMeanPercentScore;
    }

    public function setEndSelfMeanPercentScore(?string $endSelfMeanPercentScore): self
    {
        $this->endSelfMeanPercentScore = $endSelfMeanPercentScore;

        return $this;
    }

    public function getEndActualMeanPercentScore(): ?string
    {
        return $this->endActualMeanPercentScore;
    }

    public function setEndActualMeanPercentScore(?string $endActualMeanPercentScore): self
    {
        $this->endActualMeanPercentScore = $endActualMeanPercentScore;

        return $this;
    }

    public function getStatus(): ?string
    {
        return $this->status;
    }

    public function setStatus(?string $status): self
    {
        $this->status = $status;

        return $this;
    }

    public function getStartDate(): ?\DateTimeInterface
    {
        return $this->startDate;
    }

    public function setStartDate(?\DateTimeInterface $startDate): self
    {
        $this->startDate = $startDate;

        return $this;
    }

    public function getEndDate(): ?\DateTimeInterface
    {
        return $this->endDate;
    }

    public function setEndDate(?\DateTimeInterface $endDate): self
    {
        $this->endDate = $endDate;

        return $this;
    }
}
