<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use App\Repository\TAppraisalDevelopmentPlansRepository;
use Doctrine\ORM\Mapping as ORM;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;

use ApiPlatform\Core\Annotation\ApiFilter;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\SearchFilter;
use ApiPlatform\Core\Serializer\Filter\PropertyFilter;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * @ApiResource(
 *    normalizationContext={"groups"={"t_appraisal_development_plans:read"}, "enable_max_depth"="true", "swagger_definition_name"="Read"},
 *    denormalizationContext={"groups"={"t_appraisal_development_plans:write"}, "swagger_definition_name"="Write"}
 * )
 * @ApiFilter(SearchFilter::class, properties={ "id": "exact", "appraisal": "exact" })
 * @ApiFilter(PropertyFilter::class)
 * @ORM\Entity(repositoryClass=TAppraisalDevelopmentPlansRepository::class)
 */

class TAppraisalDevelopmentPlans
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     * @Groups({ "t_appraisal_development_plans:read", "t_appraisal_development_plans:write" })
     */
    private $id;

    /**
     * @ORM\Column(type="text", nullable=true)
     * @Groups({ "t_appraisal_development_plans:read", "t_appraisal_development_plans:write" })
     */
    private $item;

    /**
     * @ORM\Column(type="text", nullable=true)
     * @Groups({ "t_appraisal_development_plans:read", "t_appraisal_development_plans:write" })
     */
    private $trainingDuration;

    /**
     * @ORM\ManyToOne(targetEntity=TAppraisals::class, inversedBy="tAppraisalDevelopmentPlans")
     * @Groups({ "t_appraisal_development_plans:read", "t_appraisal_development_plans:write" })
     */
    private $appraisal;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getItem(): ?string
    {
        return $this->item;
    }

    public function setItem(?string $item): self
    {
        $this->item = $item;

        return $this;
    }

    public function getTrainingDuration(): ?string
    {
        return $this->trainingDuration;
    }

    public function setTrainingDuration(?string $trainingDuration): self
    {
        $this->trainingDuration = $trainingDuration;

        return $this;
    }

    public function getAppraisal(): ?TAppraisals
    {
        return $this->appraisal;
    }

    public function setAppraisal(?TAppraisals $appraisal): self
    {
        $this->appraisal = $appraisal;

        return $this;
    }
}
